@extends('backend.layouts.app')

@section('title')
    {{ __($module_title) }}
@endsection

@push('after-styles')
<!-- DataTables Core and Extensions -->
<link rel="stylesheet" href="{{ asset('vendor/datatable/datatables.min.css') }}">
@endpush

@section('content')
<div class="card">
  <div class="card-body">
    <x-backend.section-header>
      <div>
        <x-backend.quick-action url="{{route('backend.branch.bulk_action')}}">
          <div class="">
            <select name="action_type" class="form-control select2 col-12" id="quick-action-type" style="width:100%">
                <option value="">{{ __('messages.no_action') }}</option>
                <option value="change-status">{{ __('messages.status') }}</option>
                <option value="delete">{{ __('messages.delete') }}</option>
            </select>
          </div>
          <div class="select-status d-none quick-action-field" id="change-status-action">
              <select name="status" class="form-control select2" id="status" style="width:100%">
                <option value="1">{{ __('messages.active') }}</option>
                <option value="0">{{ __('messages.inactive') }}</option>
              </select>
          </div>
        </x-backend.quick-action>
      </div>
    </x-backend.section-header>
    {!! $dataTable->table() !!}
  </div>
</div>

<div data-render="app">
  <branch-gallery-offcanvas></branch-gallery-offcanvas>
  <assign-branch-employee-offcanvas></assign-branch-employee-offcanvas>
</div>
@endsection

@push('after-scripts')
  <script type="text/javascript" src="{{ asset('vendor/datatable/datatables.min.js') }}"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
  <script type="text/javascript" src="{{ asset('vendor/datatables/buttons.server-side.js') }}"></script>
  {!! $dataTable->scripts() !!}
@endpush
