<?php

namespace Modules\CustomTemplate\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\CustomTemplate\Models\CustomTemplate;

class CustomTemplateDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks!
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        /*
         * CustomTemplates Seed
         * ------------------
         */

         if (env('IS_DUMMY_DATA')) {
            $data = [
              
              
            [
                'template_name' => 'Blog Conclusion',
                'description' => 'End your blog posts on a high note. Craft memorable conclusions that leave a lasting impact.',
                'category_id' => 1,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Title of the blog text","description":"Enter Title of the blog text","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write blog post conclusion about title: ##INPUT-0##. And the description is ##INPUT-1##.Maximum ##INPUT-3## words. Creativity is  ##INPUT-5## between 0 and 1. Language is ##INPUT-2## US. Generate ##INPUT-4## different blog conclusions. Tone of voice must be ##INPUT-6##.',
                'feature_image' => public_path('/dummy-images/custom_template/blog.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:02',
                'updated_at' => '2024-02-21 10:56:06',
            ],
            [
                'template_name' => 'Youtube Video Description',
                'description' => 'Elevate your YouTube content with compelling video descriptions. Generate engaging descriptions effortlessly and increase views.',
                'category_id' => 4,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"},{"title":"Italian","description":"","icon":" ","value":"Italian"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => '"Generate one paragraph about:  \'##INPUT-0## \'. Keywords are ##INPUT-1##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different paragraphs. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/youtube.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:02',
                'updated_at' => '2024-02-21 10:56:40',
            ],
            [
                'template_name' => 'Pros and Cons',
                'description' => 'Make informed decisions with ease. Generate unbiased pros and cons lists that help you weigh options and make better choices.',
                'category_id' => 2,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":"400 ","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Generate pros & cons about title:  \'##INPUT-1##\'. Description is  ##INPUT-0##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different pros&cons. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Pros and Cons.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:02',
                'updated_at' => '2024-02-21 10:57:10',
            ],
            [
                'template_name' => 'Google Ads Headlines',
                'description' => 'Create high-converting Google ads with captivating headlines. Generate unique, clickable ads that drive traffic and boost sales.',
                'category_id' => 3,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Product Name","description":"Enter Product Name","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Audience","description":"Select Audience","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Everyone","description":"","icon":" ","value":"Everyone"},{"title":"Woman","description":"","icon":" ","value":"Woman"},{"title":"Man","description":"","icon":" ","value":"Man"},{"title":"Children","description":"","icon":" ","value":"Children"},{"title":"Teenager","description":"","icon":" ","value":"Teenager"}],"selected":"single_select"},{"index":3,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":4,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":6,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":7,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-7##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write Google ads headline product name: ##INPUT-0##. Description is ##INPUT-1##. Audience is ##INPUT-2##. Maximum  ##INPUT-4##  words. Creativity is ##INPUT-6## between 0 and 1. Language is ##INPUT-3##. Generate ##INPUT-5## different google ads headlines. Tone of voice must be ##INPUT-7##',
                'feature_image' => public_path('/dummy-images/custom_template/ads.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:02',
                'updated_at' => '2024-02-21 10:57:27',
            ],
            [
                'template_name' => 'Instagram Captions',
                'description' => 'Elevate your Instagram game with captivating captions. Generate unique captions that engage followers and increase your reach.',
                'category_id' => 4,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"},{"title":"Italian","description":"","icon":" ","value":"Italian"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => '"Generate one paragraph about:  \'##INPUT-0## \'. Keywords are ##INPUT-1##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different paragraphs. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Instagram Captions.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:02',
                'updated_at' => '2024-02-21 10:57:58',
            ],
            [
                'template_name' => 'Meta Description',
                'description' => 'Get more clicks with compelling meta descriptions. Generate unique, SEO-friendly meta descriptions that attract customers and boost traffic.',
                'category_id' => 2,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Generate pros & cons about title:  \'##INPUT-1##\'. Description is  ##INPUT-0##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different pros&cons. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Meta Description.png'),
                'created_by' => NULL,
                'updated_by' => 1,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-19 06:37:03',
                'updated_at' => '2024-02-21 10:58:25',
            ],
            [
                'template_name' => 'Article Generator',
                'description' => 'Instantly create unique articles on any topic. Boost engagement, improve SEO, and save time.',
                'category_id' => 1,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Article Title","description":"Enter Article Title","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Focus Keywords (Seperate with Comma)","description":"Enter Focus Keywords (Seperate with Comma)","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Enter Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":0,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Generate article about ##INPUT-0##. Focus on ##INPUT-1##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is  ##INPUT-2## . Generate ##INPUT-4## different articles. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/article.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 10:08:38',
                'updated_at' => '2024-02-21 10:08:38',
            ],
            [
                'template_name' => 'Paragraph Generator',
                'description' => 'Generate a paragraph with keywords and description. Never struggle with writer\'s block again. Generate flawless paragraphs that captivate readers.',
                'category_id' => 1,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Keywords (Separate with comma.)","description":"Enter Keywords (Separate with comma.)","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Generate one paragraph about:  ##INPUT-0## . Keywords are ##INPUT-1## . Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different paragraphs. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Paragraph.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 10:21:40',
                'updated_at' => '2024-02-21 10:21:40',
            ],
            [
                'template_name' => 'Grammar Correction',
                'description' => 'Eliminate grammar errors and enhance your writing with ease. Our tool offers seamless grammar correction for flawless content.',
                'category_id' => 1,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Correct this to standard English US. Text is ##INPUT-0##. Maximum ##INPUT-2## words. Creativity is ##INPUT-4## between 0 and 1. Language is ##INPUT-1##. Generate ##INPUT-3## different grammar correction. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/Grammar.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 10:42:08',
                'updated_at' => '2024-02-21 10:42:08',
            ],
            [
              
                'template_name' => 'TLDR Summarization',
                'description' => 'Automatically summarize long texts into bite-sized summaries with this TL;DR generator.',
                'category_id' => 1,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => '##INPUT-0## . Tl;dr Maximum ##INPUT-2##  words. Creativity is ##INPUT-4##  between 0 and 1. Language is ##INPUT-1##. Generate ##INPUT-3## different tl;dr. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/TLDR.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 10:54:56',
                'updated_at' => '2024-02-21 10:54:56',
            ],
            [
                'template_name' => 'Google Ads Description',
                'description' => 'Step up your Google ad game, Craft high-converting ad copy that grabs attention and drives sales.',
                'category_id' => 3,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Product Name","description":"Enter Product Name","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Audience","description":"Select Audience","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Everyone","description":"","icon":" ","value":"Everyone"},{"title":"Woman","description":"","icon":" ","value":"Woman"},{"title":"Man","description":"","icon":" ","value":"Man"},{"title":"Children","description":"","icon":" ","value":"Children"},{"title":"Teenager","description":"","icon":" ","value":"Teenager"}],"selected":"single_select"},{"index":3,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":4,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":6,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":7,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-7##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write google ads description product name: ##INPUT-0##. Description is ##INPUT-1##. Audience is ##INPUT-2##. Maximum ##INPUT-5## words. Creativity is ##INPUT-6## between 0 and 1. Language is ##INPUT-3##. Generate ##INPUT-5## different google ads description. Tone of voice must be ##INPUT-7##',
                'feature_image' => public_path('/dummy-images/custom_template/ads.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:14:56',
                'updated_at' => '2024-02-21 11:14:56',
            ],
            [
                'template_name' => 'Social Media Post Business',
                'description' => 'Generate a text for your business social media networks. Maximize your social media presence with impactful business posts.',
                'category_id' => 4,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Company Name","description":"Enter Company Name","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Company Description","description":"Enter Company Description","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write in company social media post, company name: ##INPUT-0##. About: ##INPUT-1##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different social media posts. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Social Media Post Business.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:24:58',
                'updated_at' => '2024-02-21 11:24:58',
            ],
            [
                'template_name' => 'Facebook Headlines',
                'description' => 'Get noticed with attention-grabbing Facebook headlines. Generate unique, clickable headlines that increase engagement and drive traffic.',
                'category_id' => 4,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write Facebook ads title about title: ##INPUT-0##. And description is ##INPUT-1##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different facebook ads title. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Facebook Headlines.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:34:36',
                'updated_at' => '2024-02-21 11:34:36',
            ],
            [
                
                'template_name' => 'Social Media Post Tweet',
                'description' => 'Make an impact with every tweet. Generate attention-grabbing social media posts and increase engagement.',
                'category_id' => 4,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Title","description":"Enter Title","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write in 1st person tweet about ##INPUT-0##. Maximum ##INPUT-2## words. Creativity is ##INPUT-4## between 0 and 1. Language is ##INPUT-1##. Generate ##INPUT-3## different tweets. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/Social Media Post Tweet.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:46:02',
                'updated_at' => '2024-02-21 11:46:02',
            ],
            [
                
                'template_name' => 'FAQ Generator',
                'description' => 'Quickly create helpful FAQs. Our AI-powered generator provides custom responses to common questions in seconds.',
                'category_id' => 2,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Title","description":"Enter Description","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":"  ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":"1 ","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Enter Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Enter Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Answer like faq about subject: ##INPUT-1## Description is ##INPUT-0##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5##  between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4##  different faqs. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/FAQ Generator.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:09:00',
                'updated_at' => '2024-02-21 11:09:00',
            ],
            [
                'template_name' => 'Instagram Hashtags',
                'description' => 'Boost your Instagram reach with relevant hashtags. Generate optimal, trending hashtags and increase your visibility.',
                'category_id' => 4,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Keywords","description":"Enter Keywords","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":"1 ","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Enter Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Enter Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write instagram hastags for ##INPUT-0##. Maximum  ##INPUT-2##  words. Creativity is##INPUT-4##  between 0 and 1. Language is ##INPUT-1##. Generate ##INPUT-3##  different instagram hashtags. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/Instagram Hashtags.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-21 11:47:57',
                'updated_at' => '2024-02-21 11:47:57',
            ],
            [
                'template_name' => 'Testimonial Review',
                'description' => 'Instantly generate authentic testimonials. Build trust and credibility with genuine reviews.',
                'category_id' => 4,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Subject","description":"Enter Subject","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian ","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.5"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":" Professional"},{"title":" Funny","description":"","icon":" ","value":" Funny"},{"title":" Casual","description":"","icon":" ","value":" Casual"},{"title":" Excited","description":"","icon":" ","value":" Excited"},{"title":" Witty","description":"","icon":" ","value":" Witty"},{"title":" Sarcastic","description":"","icon":" ","value":" Sarcastic"},{"title":" Feminine","description":"","icon":" ","value":" Feminine"},{"title":" Masculine","description":"","icon":" ","value":" Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Generate testimonial for ##INPUT-0##. Include details about how it helped you and what you like best about it. Be honest and specific, and feel free to get creative with your wording Maximum ##INPUT-2##  words. Creativity is ##INPUT-4##  between 0 and 1. Language is ##INPUT-1## . Generate ##INPUT-3## different testimonials. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/Testimonial Review.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-22 10:53:26',
                'updated_at' => '2024-02-22 10:53:26',
            ],
            [
                
                'template_name' => 'Email Generator',
                'description' => 'Generate an email with your subject and description. Streamline your inbox and save time.',
                'category_id' => 2,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Subject of Email","description":"Enter Subject of Email","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":3,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":" Economic","description":"","icon":" ","value":"0.25"},{"title":" Average","description":"","icon":" ","value":"0.5"},{"title":" Good","description":"","icon":" ","value":"0.75"},{"title":" Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":6,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'Write email about title: ##INPUT-1##, description: ##INPUT-0##. Maximum ##INPUT-3## words. Creativity is ##INPUT-5## between 0 and 1. Language is ##INPUT-2##. Generate ##INPUT-4## different emails. Tone of voice must be ##INPUT-6##',
                'feature_image' => public_path('/dummy-images/custom_template/Email Generator.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-22 11:08:51',
                'updated_at' => '2024-02-22 11:08:51',
            ],
            [
                
                'template_name' => 'Email Answer Generator',
                'description' => 'Effortlessly tackle your overflowing inbox with custom, accurate responses to common queries, freeing you up to focus on what matters most.',
                'category_id' => 2,
                'package_id' => 2,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description ","description":"Enter Description ","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":2,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":4,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.5"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":5,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'answer this email content: ##INPUT-0##. Maximum ##INPUT-2## words. Creativity is ##INPUT-4## between 0 and 1. Language is ##INPUT-1##. Generate ##INPUT-3## different email answers. Tone of voice must be ##INPUT-5##',
                'feature_image' => public_path('/dummy-images/custom_template/Email Answer Generator.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-22 11:17:25',
                'updated_at' => '2024-02-22 11:17:25',
            ],
            [
                'template_name' => 'Newsletter Generator',
                'description' => 'Generate engaging newsletters easily with personalized content that resonates with your audience, driving growth and engagement.',
                'category_id' => 3,
                'package_id' => 1,
                'status' => 1,
                'inculde_voice_tone' => 1,
                'userinput_list' => '[{"index":0,"input_title":"Description","description":"Enter Description","input_type":"textarea","input_tag":"##INPUT-0##","is_required":1,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":1,"input_title":"Title","description":"Enter Title","input_type":"text_input","input_tag":"##INPUT-1##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":2,"input_title":"Subject","description":"Enter Subject","input_type":"text_input","input_tag":"##INPUT-2##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"","description":"","icon":""}]},{"index":3,"input_title":"Language","description":"Select Language","input_type":"single_select","input_tag":"##INPUT-3##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"English","description":"","icon":" ","value":"English"},{"title":"Arabic","description":"","icon":" ","value":"Arabic"},{"title":"Dutch","description":"","icon":" ","value":"Dutch"},{"title":"French","description":"","icon":" ","value":"French"},{"title":"Italian","description":"","icon":" ","value":"Italian"},{"title":"Spanish","description":"","icon":" ","value":"Spanish"}],"selected":"single_select"},{"index":4,"input_title":"Maximum Length","description":"Enter Maximum Length","input_type":"number_input","input_tag":"##INPUT-4##","is_required":1,"package_id":null,"default_value":" 400","option_data":[{"title":"","description":"","icon":""}]},{"index":5,"input_title":"Number of Results","description":"Enter Number of Results","input_type":"number_input","input_tag":"##INPUT-5##","is_required":1,"package_id":null,"default_value":" 1","option_data":[{"title":"","description":"","icon":""}]},{"index":6,"input_title":"Creativity","description":"Select Creativity","input_type":"single_select","input_tag":"##INPUT-6##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Economic","description":"","icon":" ","value":"0.25"},{"title":"Average","description":"","icon":" ","value":"0.5"},{"title":"Good","description":"","icon":" ","value":"0.75"},{"title":"Premium","description":"","icon":" ","value":"1"}],"selected":"single_select"},{"index":7,"input_title":"Tone of Voice","description":"Select Tone of Voice","input_type":"single_select","input_tag":"##INPUT-7##","is_required":1,"package_id":null,"default_value":" ","option_data":[{"title":"Professional","description":"","icon":" ","value":"Professional"},{"title":"Funny","description":"","icon":" ","value":"Funny"},{"title":"Casual","description":"","icon":" ","value":"Casual"},{"title":"Excited","description":"","icon":" ","value":"Excited"},{"title":"Witty","description":"","icon":" ","value":"Witty"},{"title":"Sarcastic","description":"","icon":" ","value":"Sarcastic"},{"title":"Feminine","description":"","icon":" ","value":"Feminine"},{"title":"Masculine","description":"","icon":" ","value":"Masculine"}],"selected":"single_select"}]',
                'option_data' => NULL,
                'custom_prompt' => 'generate newsletter template about product_title: ##INPUT-1##, reason: ##INPUT-2## description: ##INPUT-0##. Maximum ##INPUT-4## words. Creativity is ##INPUT-6## between 0 and 1. Language is ##INPUT-3##. Generate ##INPUT-5## different newsletter template. Tone of voice must be ##INPUT-7##',
                'feature_image' => public_path('/dummy-images/custom_template/Newsletter.png'),
                'created_by' => NULL,
                'updated_by' => NULL,
                'deleted_by' => NULL,
                'deleted_at' => NULL,
                'created_at' => '2024-02-22 11:19:34',
                'updated_at' => '2024-02-22 11:19:34',
            ],
                    

            ];
            foreach ($data as $key => $value) {
                $featureImage = $value['feature_image'] ?? null;
                $service = [
                    'template_name' => $value['template_name'],
                    'description' => $value['description'],
                    'category_id' => $value['category_id'],
                    'package_id' => $value['package_id'],
                    'status' => $value['status'],
                    'inculde_voice_tone' => $value['inculde_voice_tone'],
                    'userinput_list' => $value['userinput_list'],
                    'option_data' => $value['option_data'],
                    'custom_prompt' => $value['custom_prompt'],
                ];
                $service = CustomTemplate::create($service);
                if (isset($featureImage)) {
                    $this->attachFeatureImage($service, $featureImage);
                }
            }
        }
        // Enable foreign key checks!
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
    private function attachFeatureImage($model, $publicPath)
    {
        if(!env('IS_DUMMY_DATA_IMAGE')) return false;

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('feature_image');

        return $media;
    }
}
